//
// XBlast Robot File
//
// (C) by Immanuel Halupczok <xblast@karimmi.de>
// based on code and containing parts
// (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2; or (at your option)
// any later version
//
// This program is distributed in the hope that it will be entertaining,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.
// 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

#include "frames.inc"

//
// froce field and other FX
//
#ifndef (activateForceField)
  #declare activateForceField = 0;
#end
#ifndef (forceFieldPhase)
  #declare forceFieldPhase = 0.0;
#end

//
// sick player
//
#ifndef (playerIsSick)
  #declare playerIsSick=0;
#end

//
// additional colors
//
#ifndef (beltColor)
#declare beltColor = color rgb <0.1,0.1,0.1>;
#end

//
// no face (needed helmet for helmet camera)
//
#ifndef (noFace)
#declare noFace = 0;
#end

#include "XBlastTexture.inc"




#declare gesichtTexture =
texture {
  pigment {faceColor}
  finish {Dull ambient ambientHigh}
  #if (playerDamaged != 0)
    normal {dents 1.0 scale 0.25}
  #end
}


//
// include force field
//
#if (activateForceField = 1)
  #include "XBlast Force Field.inc"
#end

//
// the head
//

#declare epsi = 0.0001;
#declare armdicke = 0.15;
#declare beindicke = 0.15;
#declare RR = seed(0);
#declare RRD = seed(1); // Zusatz-Random fr damage


#macro bogen(rgross, rklein, w1, w2)
  intersection {
    torus {rgross, rklein}
    plane {x, 0 rotate w1*y}
    plane {-x, 0 rotate w2*y}
  }

#end



#declare haar = intersection {
  bogen(0.7, 0.05, 0, 45)
  rotate -90*z
  translate <0, 0, 0.5>
  texture {helmetTexture}
}


#macro Auge(richtung)
union {
  intersection {
    sphere {<0, 0, 0>, 1.3}
    plane {-z, 0}
    texture {gesichtTexture}
  }
  sphere {<0, 0, 0>, 1
    pigment {White * 1.1}
    finish {Shiny}
  }
  intersection {
    sphere {<0, 0, 0>, 1+epsi}
    sphere {<0, 0, -1>, 0.5}
    #if (playerDamaged)
      pigment {White / 2}
    #else
      pigment {Black}
    #end
    finish {Shiny}
    rotate richtung
  }


  scale <0.2,0.2,0.2>

  
//  texture {eyeTexture}
}
#end

#declare LinkesOhr = difference {
  sphere {<0,0,0> 0.3 scale <0.5,1,0.8>}
  sphere {<-0.2,0,0> 0.2 scale <0.5,1,0.8>}
}


#declare PlayerHead = union {
  union {
    sphere {<0, 0, 0>, 0.8}
    #if (playerDamaged)
      intersection {
        sphere {<0, 0, -0.8>, 0.3} // Nase
	sphere {<0, 0, -0.6>, 0.4}
	scale <1,1,1.2>
      }
    #else
      sphere {<0, 0, -0.8>, 0.3 scale <1,1,1.2>} // Nase
    #end
    object { LinkesOhr translate <-0.75, 0, 0> }
    object { LinkesOhr translate <-0.75, 0, 0> scale <-1, 1, 1>}
    texture {gesichtTexture}
  }
  #if (playerDamaged)
    object { Auge(<-15, 30, 0>) translate <-0.3, 0.3, -0.6> }
    object { Auge(<35, 5, 0>) translate < 0.3, 0.3, -0.6> }
  #else
    object { Auge(<-5, 0, 0>) translate <-0.3, 0.3, -0.6> }
    object { Auge(<-5, 0, 0>) translate < 0.3, 0.3, -0.6> }
  #end

  union {
    #local ii = 0;
    #while (ii < 60)
      object {
        haar
	rotate (rand(RR)*60-30)*y
	#if (playerDamaged)
	  rotate (rand(RRD)*240 - 120)*y
	#end
	translate <rand(RR)*0.6-0.3, 0, rand(RR)*0.6-0.3>
        translate <0, 0.8, 0>
	rotate max(rand(RR),rand(RR))*80*x
	rotate (rand(RR)*180-90)*y
      }
      #local ii = ii + 1;
    #end
  }

  translate <0, 0.6, 0>
  rotate headAngle
  translate <0,-0.6, 0>
}


//
// the body
//
#declare PlayerBody =
union {
  // main body
  sphere {
    <0,0,0>, 0.6
    texture {bodyTexture}
  }
  cylinder {
    <0, 0, 0>, <0, 1, 0>, 0.2
    texture {gesichtTexture}
  }
}


#declare PlayerRightHand =
union {
  sphere {
    <0,0,0>, 0.2
  }
  texture {gesichtTexture}
}

#declare PlayerRightLowerArm =
union {
 object {
    PlayerRightHand
    translate <-0.6,0,0>
  }
  sphere {
    <-0.4,0,0>, armdicke
  }
  cylinder {
    <0, 0, 0> <-0.4, 0, 0> armdicke
  }
}

#declare PlayerRightUpperArm =
union {
  object {
    PlayerRightLowerArm
    rotate rightLowerArmAngle
    translate x*-0.5
  }
  union {
    sphere {
      <0,0,0>, armdicke
    }
    cylinder {
      <0, 0, 0> <-0.4, 0, 0> armdicke
    }
    sphere {
      <-0.4,0,0>, armdicke
    }
  }
}

#declare PlayerRightArm =
union {
  object {
    PlayerRightUpperArm
    rotate rightArmAngle
  }
/*  intersection {
    plane  { -x, 0 }
    sphere { <0,0,0>, 1 }
    scale <0.6, 0.3, 0.3>
  }*/
  texture {armsLegsTexture}
}

//
// Left arm of player, includings hands
//

#declare PlayerLeftHand =
union {
  sphere {
    <0,0,0>, 0.2
  }
  texture {gesichtTexture}
}

#declare PlayerLeftLowerArm =
union {
 object {
    PlayerLeftHand
    translate <0.6,0,0>
  }
  sphere {
    <0.4,0,0>, armdicke
  }
  cylinder {
    <0, 0, 0> <0.4, 0, 0> armdicke
  }
}

#declare PlayerLeftUpperArm =
union {
  object {
    PlayerLeftLowerArm
    rotate leftLowerArmAngle
    translate x*0.4
  }
  union {
    sphere {
      <0,0,0>, armdicke
    }
    cylinder {
      <0, 0, 0> <0.4, 0, 0> armdicke
    }
    sphere {
      <0.4,0,0>, armdicke
    }
  }
}

#declare PlayerLeftArm =
union {
  object {
    PlayerLeftUpperArm
    rotate leftArmAngle
  }
/*  intersection {
    plane  { x, 0 }
    sphere { <0,0,0>, 1 }
    scale <0.6, 0.3, 0.3>
  }*/
  texture {armsLegsTexture}
}

//
// legs
//

#declare PlayerFoot =
union {
  intersection {
    sphere { <0,0,0>, 1 }
    plane  { -y, 0 }
    scale <0.4,0.4,0.4>
  }
  texture {handsFeetTexture}
}

#declare PlayerLowerRightLeg =
union {
  object {
    PlayerFoot
    translate <0.0,-0.3,-0.1>
    rotate rightFootAngle
    translate <0.0,-0.4,0.0>
  }
  sphere {
    <0,-0.4,0>, beindicke
  }
  cylinder {
    <0,0,0>, <0,-0.4,0>, beindicke
  }
}

#declare PlayerUpperRightLeg =
union {
  object {
    PlayerLowerRightLeg
    rotate rightLowerLegAngle
    translate <0.0,-0.4,0.0>
  }
  sphere {
    <0,0,0>, beindicke
  }
  sphere {
    <0,-0.4,0>, beindicke
  }
  cylinder {
    <0,0,0>, <0,-0.4,0>, beindicke
  }
}

#declare PlayerRightLeg =
object {
    PlayerUpperRightLeg
    rotate rightLegAngle
    texture {armsLegsTexture}
}



#declare PlayerLowerLeftLeg =
union {
  object {
    PlayerFoot
    translate <0.0,-0.3,-0.1>
    rotate leftFootAngle
    translate <0.0,-0.4,0.0>
  }
  sphere {
    <0,-0.4,0>, beindicke
  }
  cylinder {
    <0,0,0>, <0,-0.4,0>, beindicke
  }
}

#declare PlayerUpperLeftLeg =
union {
  object {
    PlayerLowerLeftLeg
    rotate leftLowerLegAngle
    translate <0.0,-0.4,0.0>
  }
  sphere {
    <0,0,0>, beindicke
  }
  sphere {
    <0,-0.4,0>, beindicke
  }
  cylinder {
    <0,0,0>, <0,-0.4,0>, beindicke
  }
}

#declare PlayerLeftLeg =
object {
  PlayerUpperLeftLeg
  rotate leftLegAngle
  texture {armsLegsTexture}
}



#declare Player =
union {
  object {PlayerHead     translate < 0.00, 3.25, 0.00> }
  object {PlayerBody     translate < 0.00, 1.70, 0.00> }
  object {PlayerLeftArm  translate < 0.6, 1.9, 0.00> }
  object {PlayerRightArm translate <-0.6, 1.9, 0.00> }
  object {PlayerRightLeg translate <-0.30, 1.20, 0.00> }
  object {PlayerLeftLeg  translate < 0.30, 1.20, 0.00> }
#if (activateForceField = 1)
  object {ForceField}
#end
  translate <0.0, -1.20, 0.0>
  rotate bodyAngle
  translate <0.0,  1.20, 0.0>
  translate y*playerWalkHeight
  rotate playerAngle
  translate playerLocation
}

object {Player}


//
// end file "XBlast Robot.inc"//
